-- Average Enjoyer ^ω^ Lampovo Project
-- vk.com/lampovofs

licensePlatesStandalone = {}
licensePlatesStandalone.modDir = g_currentModDirectory

LicensePlateManager.loadMapData = Utils.overwrittenFunction(LicensePlateManager.loadMapData, function (self, superFunc, xmlFile, missionInfo, baseDirectory)
    LicensePlateManager:superClass().loadMapData(self, xmlFile, missionInfo, baseDirectory)

    LicensePlateManager.createLicensePlateXMLSchema()

    local filename = getXMLString(xmlFile, "map.licensePlates#filename")
    if filename ~= nil then
        self.xmlFilename = Utils.getFilename('data/licensePlates.xml', licensePlatesStandalone.modDir)
        self.licensePlateXML = XMLFile.load("mapLicensePlates", self.xmlFilename, LicensePlateManager.xmlSchema)
        if self.licensePlateXML ~= nil then
            self.xmlReferences = 0
            self:loadLicensePlatesFromXML(self.licensePlateXML, licensePlatesStandalone.modDir)

            if self.licensePlateXML ~= nil and self.xmlReferences == 0 then
                self.licensePlateXML:delete()
                self.licensePlateXML = nil
            end
        end
    end

    return true
end)

LicensePlateDialog.updateVariations = Utils.overwrittenFunction(LicensePlateDialog.updateVariations, function (self, superFunc)
    local texts = {}

    for i = 1, #self.licensePlate.variations do
        local typeText = g_i18n:getText("ui_licensePlateType" .. i)
        table.insert(texts, typeText)
    end

    self.typeOption:setTexts(texts)
    self.typeOption:setState(self.currentVariation)
end)

LicensePlate.setVariation = Utils.overwrittenFunction(LicensePlate.setVariation, function (self, superFunc, variationIndex)
    local variation = self.variations[variationIndex]
    if variation ~= nil then
        local oldVariation = self.variations[self.variationIndex]
        for i=1, #oldVariation.values do
            local value = oldVariation.values[i]
            if not value.isStatic then
                for j=1, getNumOfChildren(value.node) do
                    delete(getChildAt(value.node, j - 1))
                end
            end
        end

        self.variationIndex = variationIndex

        if variationIndex == 15 then
            colorIndex = 2
            self.fontScaleX = 0.95
        else
            colorIndex = 1
            self.fontScaleX = 0.85
        end

        if variationIndex == 13 or variationIndex == 14 then
            self.width = 0.34
            self.height = 0.11
        else
            if self.type == LicensePlateManager.PLATE_TYPE.ELONGATED then
                self.width = 0.52
                self.height = 0.11
            else
                self.width = 0.3
                self.height = 0.2
            end
        end

        for i=1, #variation.values do
            local value = variation.values[i]

            if not value.isStatic then
                value.characterLine = CharacterLine.new(value.node, self.font, 1)
                value.characterLine:setSizeAndScale(self.fontSize, self.fontScaleX, self.fontScaleY)
                value.characterLine:setTextAlignment(RenderText.ALIGN_CENTER)
                value.characterLine:setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_MIDDLE)
            end
        end

        for i=1, #variation.materials do
            local material = variation.materials[i]
            material:apply(self.node)
        end

        local colors, _ = self.manager:getAvailableColors()
        local textColor = colors[colorIndex]
        self:setColor(textColor.color[1], textColor.color[2], textColor.color[3])
    end
end)

LicensePlate.setColor = Utils.overwrittenFunction(LicensePlate.setColor, function (self, superFunc, r, g, b)
    for j=1, #self.variations do
        for i=1, #self.variations[j].values do
            local value = self.variations[j].values[i]
            if not value.isStatic then
                if value.node ~= nil then
                    I3DUtil.setShaderParameterRec(value.node, g_licensePlateManager.shaderParameterCharacters, r, g, b)
                end
            end
        end
    end
end)

LicensePlate.setColorIndex = Utils.overwrittenFunction(LicensePlate.setColorIndex, function (self, superFunc, colorIndex)
end)